const express = require("express");

const teleporterControllers = require("../controllers/teleporterControllers");

const router = express.Router();

router.post("/", teleporterControllers.create);
router.put("/:id", teleporterControllers.edit);
router.get("", teleporterControllers.getAll);
router.delete("/:id", teleporterControllers.delete);
router.get("/:id", teleporterControllers.getById);
router.post(
  "/available/page/:page/limit/:limit",
  teleporterControllers.searchForTraveler
);
router.post(
  "/search/:user_id/page/:page/limit/:limit",
  teleporterControllers.search
);
router.get(
  "/active/:teleporterId/page/:page/limit/:limit",
  teleporterControllers.activeTeleports
);
router.get(
  "/history/:userId/page/:page/limit/:limit",
  teleporterControllers.historyTeleports
);

module.exports = router;
