const express = require("express");

const senderControllers = require("../controllers/senderControllers");

const router = express.Router();

router.post("/", senderControllers.create);
router.put("/:id", senderControllers.edit);
router.get("/", senderControllers.getAll);
router.delete("/:id", senderControllers.delete);
router.get("/:id", senderControllers.getById);
router.post(
  "/search/:user_id/page/:page/limit/:limit",
  senderControllers.search
);
router.get(
  "/active/:userId/page/:page/limit/:limit",
  senderControllers.activePackages
);
router.get(
  "/history/:userId/page/:page/limit/:limit",
  senderControllers.historyPackages
);

module.exports = router;
