const express = require("express");

const chatControllers = require("../controllers/chatControllers");

const router = express.Router();

router.post("/", chatControllers.create);
router.get("/:user_id/page/:page/limit/:limit", chatControllers.getAll);
router.get(
  "/messages/:chat_id/page/:page/limit/:limit",
  chatControllers.getAllMessages
);
router.post("/createMessage", chatControllers.createMessage);
router.post("/search/:user_id/page/:page/limit/:limit", chatControllers.search);
// router.put("/:user_id/editStatus", chatControllers.editStatus);
router.post("/uploadVoice", chatControllers.uploadVoiceMessage);
router.post("/setMessagesReaded", chatControllers.setMessagesReaded);

module.exports = router;
