const jwt = require("jsonwebtoken");

const config = process.env;

const verifyToken = (req, res, next) => {
  const token =
    req.body.token || req.query.token || req.headers["authorization"];
  if (!token) {
    return res
      .status(403)
      .json({ message: "A token is required for authentication" });
  }
  try {
    const bearerToken = token.split(" ")[1];
    const decoded = jwt.verify(bearerToken, config.TOKEN_KEY);
    req.token = decoded;
  } catch (err) {
    return res.status(401).json({ message: "Invalid token" });
  }
  return next();
};

module.exports = verifyToken;
