const db = require("../models");
const User = db.user;
const Chat = db.chat;
const Review = db.review;
const Image = db.image;
const ChatUsers = db.chatUsers;
const Op = db.Sequelize.Op;
const { paginate } = require("../helper/helper");

exports.createReview = async (req, res, next) => {
  try {
    let { user_id, author_id, fullName, stars, message } = req.body;

    // Validate user input
    if (!(user_id && author_id && fullName && stars && message)) {
      return res.status(200).send({
        status: false,
        message: "All input required!",
        data: null
      });
    }

    const newReview = {
      user_id: user_id,
      author_id: author_id,
      fullName: fullName,
      stars: stars,
      message: message
    };

    const oldReview = Review.findOne({
      where: [{ user_id: user_id }, { author_id: author_id }]
    })
      .then(data => {
        if (data) {
          return res.status(200).send({
            status: false,
            message: "You already left review for this user!",
            data: null
          });
        } else {
          Review.create(newReview)
            .then(data => {
              console.log(data);
              return res.status(200).send({
                status: true,
                message: "Success!",
                data: data
              });
            })
            .catch(err => {
              return res.status(200).send({
                status: false,
                message: err.message || "Faild!",
                data: null
              });
            });
        }
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message: err.message || "Faild!",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};
