require("dotenv").config();
const db = require("../models");
const Sender = db.sender;
const Reciver = db.reciver;
const User = db.user;
const Image = db.image;
const Op = db.Sequelize.Op;
const { paginate } = require("../helper/helper");

exports.create = async (req, res, next) => {
  try {
    let { user_id, verificationCode } = req.body;

    // Validate user input
    if (!verificationCode) {
      return res.status(200).send({
        status: false,
        message: "Verification code is required.",
        data: null
      });
    }

    const findSender = await Sender.findOne({
      where: { verificationCode: verificationCode }
    });

    if (!findSender) {
      return res.status(200).send({
        status: false,
        message: "Sender with that verification code not found.",
        data: null
      });
    }

    const findReciver = await Reciver.findOne({
      where: { verificationCode: verificationCode }
    });

    if (findReciver) {
      return res.status(200).send({
        status: false,
        message: "That verification code has ben used.",
        data: null
      });
    }
    let reciver = {};

    if (user_id) {
      reciver = {
        verificationCode: verificationCode,
        user_id: user_id,
        sender_id: findSender.id
      };
    } else {
      reciver = {
        verificationCode: verificationCode,
        sender_id: findSender.id
      };
    }

    Reciver.create(reciver)
      .then(data => {
        Sender.update(
          { status: "Completed" },
          {
            where: { verificationCode: verificationCode }
          }
        )
          .then(async num => {
            const updated = await Sender.findOne({
              where: { verificationCode: verificationCode }
            });

            return res.status(200).send({
              status: false,
              message: "Succesfull.",
              data: updated
            });
          })
          .catch(err => {
            return res.status(200).send({
              status: false,
              message: err.message || "Faild!",
              data: null
            });
          });

        // return res.send(data);
      })
      .catch(err => {
        return res
          .status(200)
          .send({ status: false, message: err.message || "Faild", data: null });
      });
  } catch (err) {
    console.log(err);
  }
};

exports.historyRecivers = async (req, res, next) => {
  // Our login logic starts here
  try {
    const { userId, page, limit } = req.params;

    if (!userId) {
      return res
        .status(200)
        .send({ status: false, message: "Missing userId.", data: null });
    }
    await Reciver.findAndCountAll({
      where: { user_id: userId },
      include: [
        {
          model: Sender,
          where: {
            verificationCode: {
              [Op.eq]: { [Op.col]: "recivers.verificationCode" }
            }
          },
          required: true,
          include: [{ model: Image }]
        }
      ],
      distinct: true,
      order: [["createdAt", "DESC"]],
      ...paginate({ currentPage: page, pageSize: limit })
    })
      .then(data => {
        if (!data["rows"] || data["rows"].length == 0) {
          return res.status(200).send({
            status: false,
            message: "There is no available history!",
            data: null
          });
        }

        return res
          .status(200)
          .send({ status: true, message: "Successfuly fetched!", data: data });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message: err.message || "Faild.",
          data: null
        });
      });
    return next();
  } catch (err) {
    console.log(err);
  }
};
