require("dotenv").config();
const db = require("../models");
var admin = require("firebase-admin");
const Notification = db.notification;
const User = db.user;
const Sender = db.sender;
const Op = db.Sequelize.Op;
const sequelize = require("sequelize");
const { paginate } = require("../helper/helper");
var serviceAccount = require("../config/teleport-408414-firebase-adminsdk-g0wca-ffb106706e copy.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount)
});
const messaging = admin.messaging();
exports.pushSend = async (title, body, data, token) => {
  var payload = {
    notification: {
      title: title,
      body: body
    },
    data: {
      data: JSON.stringify(data)
    },
    token: token
  };

  const options = {
    priority: "high"
  };
  console.log(data);

  messaging.send(payload).then(result => {
    console.log(result);
  });
};

exports.create = async (req, res, next) => {
  try {
    let {
      sender_id,
      teleporter_id,
      receiver_id,
      trip_id,
      title,
      message,
      isMessage
    } = req.body;

    // Validate user input
    if (!(title && message)) {
      return res
        .status(200)
        .send({ status: false, message: "All input is required", data: null });
    }

    const teleporter = await User.findOne({ where: { id: teleporter_id } });

    const notification = {
      sender_id: sender_id,
      teleporter_id: teleporter_id,
      receiver_id: receiver_id,
      trip_id: trip_id,
      title: title,
      message: message,
      isMessage: isMessage,
      responded: false
    };

    Notification.create(notification)
      .then(data => {
        console.log(data["dataValues"]);
        this.pushSend(
          title,
          message,
          data["dataValues"],
          teleporter.push_token
        );
        return res.status(200).send({
          status: true,
          message: "Teleporter created successfuly.",
          data: data
        });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message:
            err.message || "Some error occurred while creating the teleporter.",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

exports.getAll = async (req, res, next) => {
  // Our getAll logic starts here
  try {
    const { user_id, page, limit } = req.params;

    Notification.findAll({
      where: {
        [Op.or]: { teleporter_id: user_id, receiver_id: user_id },
        isMessage: false
      },
      order: [["createdAt", "DESC"]],
      ...paginate({ currentPage: page, pageSize: limit })
    })
      .then(data => {
        return res
          .status(200)
          .send({ status: true, message: "Successfuly fetched.", data: data });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message:
            err.message ||
            "Some error occurred while fetching the teleporters.",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

exports.getSenderById = async (req, res, next) => {
  // Our getAll logic starts here
  try {
    const { user_id } = req.params;

    Sender.findOne({
      where: {
        user_id: user_id
      },
      include: [
        {
          model: User,
          attributes: {
            exclude: [
              "token",
              "password",
              "otp",
              "active",
              "push_token",
              "device_uuid"
            ]
          }
        }
      ]
    })
      .then(data => {
        return res
          .status(200)
          .send({ status: true, message: "Successfuly fetched.", data: data });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message:
            err.message ||
            "Some error occurred while fetching the teleporters.",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

exports.setNotificationResponded = async (req, res, next) => {
  try {
    const { user_id, notification_id } = req.params;

    await Notification.update(
      { responded: true },
      {
        where: [{ id: notification_id }, { teleporter_id: user_id }]
      }
    )
      .then(data => {
        if (data == 1) {
          return res.status(200).send({
            status: true,
            message: "Success!",
            data: data
          });
        } else {
          return res.status(200).send({
            status: false,
            message: "Something went wrong!",
            data: null
          });
        }
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message:
            err.message ||
            "Some error occurred while fetching the teleporters.",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};
