const db = require("../models");
const User = db.user;
const Chat = db.chat;
const Message = db.message;
const Image = db.image;
const ChatUsers = db.chatUsers;
const Op = db.Sequelize.Op;
const socket = require("../server");
const { paginate } = require("../helper/helper");
const { param } = require("../routes/userRoutes");
var path = require("path");

// create chat if is not existing and chatUser
exports.create = async (req, res, next) => {
  try {
    let { name, chatUser } = req.body;

    // Validate user input
    if (!(name, chatUser)) {
      return res.status(200).send({
        status: false,
        message: "All input required!",
        data: null
      });
    }

    const result = await ChatUsers.findOne({
      where: {
        user_id: chatUser
      },
      group: ["chat_id"],
      having: db.Sequelize.literal("COUNT(*) > 1")
    }).then(async data => {
      if (!data) {
        const chat = {
          name: name,
          chatUser: chatUser
        };
        Chat.create(
          {
            name: name,
            chatUser: [{ user_id: chatUser[0] }, { user_id: chatUser[1] }]
          },
          { include: [{ model: ChatUsers, as: "chatUser" }] }
        )
          .then(data => {
            const newChat = Chat.findOne({
              where: { id: data["id"] },
              include: [
                {
                  model: ChatUsers,
                  as: "chatUser",
                  include: [
                    {
                      model: User,
                      attributes: {
                        exclude: ["token", "password", "otp", "active"]
                      }
                    }
                  ]
                },
                {
                  model: Message,
                  order: [["createdAt", "DESC"]],
                  limit: 1
                }
              ]
            }).then(async data => {
              var image = await Image.findOne({
                where: {
                  user_id: { [Op.ne]: chatUser[0] },
                  user_id: chatUser[1]
                }
              });
              data.setDataValue("image", image);

              var user = await ChatUsers.findOne({
                where: {
                  user_id: { [Op.ne]: chatUser[0] },
                  chat_id: data["id"]
                },
                include: [{ model: User, include: Image }]
              });
              data.setDataValue("receiver", user);
              return res.status(200).send({
                status: true,
                message: "Success!",
                data: data
              });
            });
          })
          .catch(err => {
            return res.status(200).send({
              status: false,
              message: err.message || "Faild!",
              data: null
            });
          });
      } else {
        await Chat.findOne({
          where: { id: data.chat_id },
          include: [
            {
              model: ChatUsers,
              as: "chatUser",
              include: [
                {
                  model: User,
                  attributes: {
                    exclude: ["token", "password", "otp", "active"]
                  }
                }
              ]
            },
            {
              model: Message,
              order: [["createdAt", "DESC"]],
              limit: 1
            }
          ]
        }).then(async data => {
          var image = await Image.findOne({
            where: {
              user_id: { [Op.ne]: chatUser[0] },
              user_id: chatUser[1]
            }
          });
          data.setDataValue("image", image);

          var user = await ChatUsers.findOne({
            where: {
              user_id: { [Op.ne]: chatUser[0] },
              chat_id: data.id
            },
            attributes: { exclude: ["token", "password", "otp", "active"] },
            include: [{ model: User, include: Image }]
          });
          data.setDataValue("receiver", user);
          return res.status(200).send({
            status: false,
            message: "Chat already exists!",
            data: data
          });
        });
      }
    });

    // if (!oldChat) {
    //   Chat.create(chat, {
    //     include: [{ model: db.chatUsers, as: "chatUser" }]
    //   })
    //     .then(data => {
    //       const newChat = Chat.findOne({
    //         where: { id: data["id"] },
    //         include: [
    //           {
    //             model: ChatUsers,
    //             as: "chatUser",
    //             include: [
    //               {
    //                 model: User,
    //                 attributes: {
    //                   exclude: ["token", "password", "otp", "active"]
    //                 }
    //               }
    //             ]
    //           },
    //           {
    //             model: Message,
    //             order: [["createdAt", "DESC"]],
    //             limit: 1
    //           }
    //         ]
    //       }).then(async data => {
    //         var image = await Image.findOne({
    //           where: {
    //             user_id: { [Op.ne]: chatUser[0]["user_id"] },
    //             user_id: chatUser[1]["user_id"]
    //           }
    //         });
    //         data.setDataValue("image", image);

    //         var user = await ChatUsers.findOne({
    //           where: {
    //             user_id: { [Op.ne]: chatUser[0]["user_id"] },
    //             chat_id: data["id"]
    //           },
    //           include: User
    //         });
    //         data.setDataValue("receiver", user);
    //         return res.status(200).send({
    //           status: true,
    //           message: "Success!",
    //           data: data
    //         });
    //       });
    //     })
    //     .catch(err => {
    //       return res.status(200).send({
    //         status: false,
    //         message: err.message || "Faild!",
    //         data: null
    //       });
    //     });
    // } else {
    //   const newChat = Chat.findOne({
    //     where: { id: oldChat["id"] },
    //     include: [
    //       {
    //         model: ChatUsers,
    //         as: "chatUser",
    //         include: [
    //           {
    //             model: User,
    //             attributes: {
    //               exclude: ["token", "password", "otp", "active"]
    //             }
    //           }
    //         ]
    //       },
    //       {
    //         model: Message,
    //         order: [["createdAt", "DESC"]],
    //         limit: 1
    //       }
    //     ]
    //   }).then(async data => {
    //     var image = await Image.findOne({
    //       where: {
    //         user_id: { [Op.ne]: chatUser[0]["user_id"] },
    //         user_id: chatUser[1]["user_id"]
    //       }
    //     });
    //     data.setDataValue("image", image);

    //     var user = await ChatUsers.findOne({
    //       where: {
    //         user_id: { [Op.ne]: chatUser[0]["user_id"] },
    //         chat_id: oldChat["id"]
    //       },
    //       attributes: { exclude: ["token", "password", "otp", "active"] },
    //       include: [{ model: User, include: Image }]
    //     });
    //     data.setDataValue("receiver", user);
    //     return res.status(200).send({
    //       status: false,
    //       message: "Chat already exists!",
    //       data: data
    //     });
    //   });
    // }
  } catch (err) {
    console.log(err);
  }
};

// get all chats for user id
exports.getAll = async (req, res, next) => {
  try {
    const { user_id, page, limit } = req.params;

    if (!user_id) {
      return res
        .status(200)
        .send({ status: false, message: "Missing user id.", data: null });
    }

    // console.log(image["imagePath"]);
    await User.findOne({
      where: { id: user_id },

      attributes: { exclude: ["token", "password", "otp", "active"] },
      include: [
        {
          model: Chat,
          through: {
            attributes: []
          },
          include: [
            {
              model: ChatUsers,
              as: "chatUser",
              include: [
                {
                  model: User,
                  attributes: {
                    exclude: ["token", "password", "otp", "active"]
                  }
                }
              ]
            },
            {
              model: Message,
              order: [["createdAt", "DESC"]],
              limit: 1
            }
          ]
        }
      ],
      ...paginate({ currentPage: page, pageSize: limit }),
      distinct: true,
      order: [["createdAt", "DESC"]]
    })
      .then(async data => {
        // console.log(
        //   ()
        // );
        for (let x in data["chats"]) {
          for (let i in data["chats"][x]["chatUser"]) {
            var image = await Image.findOne({
              where: {
                user_id: { [Op.ne]: user_id },
                user_id: data["chats"][x]["chatUser"][i]["user_id"]
              }
            });
            data["chats"][x].setDataValue("image", image);
          }
          var user = await ChatUsers.findOne({
            where: {
              user_id: { [Op.ne]: user_id },
              chat_id: data["chats"][x]["id"]
            },
            include: [{ model: User, include: Image }]
          });
          data["chats"][x].setDataValue("receiver", user);
        }

        // user["chats"][0]["chatUser"][0].setDataValue("image", image);
        // user["chats"][0]["chatUser"][0]["imagePath"] = image["imagePath"];
        return res.status(200).send({
          status: true,
          message: "Success!",
          data: data
        });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message: err.message || "Some error ocured!",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

// search for chat by user id and keyword
exports.search = async (req, res, next) => {
  try {
    const { user_id, page, limit } = req.params;
    let { searchTerm } = req.body;

    if (!searchTerm) {
      return res.status(200).send({
        status: false,
        message: "Input is required.",
        data: null
      });
    }
    const findAllUsersWithName = await User.findAll({
      where: { name: { [Op.like]: `%${searchTerm}%` } }
    });
    const ids = findAllUsersWithName.map(x => x.id);

    const ff = await ChatUsers.findAll({
      where: { user_id: ids }
    });

    const gg = ff.map(x => x.chat_id);

    const findUser = await User.findOne({
      where: { id: user_id },
      attributes: { exclude: ["token", "password", "otp", "active"] },
      include: [
        {
          model: Chat,
          where: { id: gg },
          through: {
            attributes: []
          },
          include: [
            {
              model: ChatUsers,
              as: "chatUser",
              include: [
                {
                  model: User,
                  attributes: {
                    exclude: ["token", "password", "otp", "active"]
                  }
                }
              ]
            },
            {
              model: Message,
              order: [["createdAt", "DESC"]],
              limit: 1
            }
          ]
        }
      ],
      ...paginate({ currentPage: page, pageSize: limit }),
      distinct: true,
      order: [["createdAt", "DESC"]]
    }).then(async data => {
      if (data) {
        for (let x in data["chats"]) {
          for (let i in data["chats"][x]["chatUser"]) {
            var image = await Image.findOne({
              where: {
                user_id: { [Op.ne]: user_id },
                user_id: data["chats"][x]["chatUser"][i]["user_id"]
              }
            });
            data["chats"][x].setDataValue("image", image);
          }
          var user = await ChatUsers.findOne({
            where: {
              user_id: { [Op.ne]: user_id },
              chat_id: data["chats"][x]["id"]
            },
            include: [
              {
                model: User,

                attributes: { exclude: ["token", "password", "otp", "active"] },

                include: Image
              }
            ]
          });
          data["chats"][x].setDataValue("receiver", user);
        }

        return res.status(200).send({
          status: true,
          message: "Success!",
          data: data
        });
      } else {
        return res.status(200).send({
          status: false,
          message: "No data for this search term!",
          data: null
        });
      }
    });
  } catch (err) {
    console.log(err);
  }
};

//get all messages by chat id
exports.getAllMessages = async (req, res, next) => {
  // Our getAll logic starts here
  try {
    const { chat_id, page, limit } = req.params;

    if (!chat_id) {
      return res.status(200).send({
        status: false,
        message: "Messages cant be found for that chat!",
        data: null
      });
    }

    await Chat.findOne({
      where: {
        id: chat_id
      },
      include: [
        {
          model: Message,
          where: { chat_id: chat_id },
          distinct: true,
          required: true,
          order: [["createdAt", "DESC"]],
          ...paginate({ currentPage: page, pageSize: limit })
        }
      ]
    })
      .then(async data => {
        // for (let x in data["messages"]) {
        //   console.log(data["messages"][x]);

        //   var image = await Image.findOne({
        //     where: { user_id: data["messages"][x]["sender_id"] }
        //   });
        //   data["messages"][x].setDataValue("image", image);
        // }

        return res.status(200).send({
          status: true,
          message: "Success!",
          data: data
        });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message: err.message || "Faild!",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

// set messages readed/false param to readed/true when user see them
exports.setMessagesReaded = async (req, res, next) => {
  const { chat_id, user_id } = req.body;

  await Message.update(
    { readed: true },
    {
      where: [{ readed: false }, { chat_id: chat_id }, { sender_id: user_id }]
    }
  ).then(data => {
    return res.status(200).send({
      status: true,
      message: "Success!",
      data: data
    });
  });
};

// we dont use this from now
exports.createMessage = async (req, res, next) => {
  try {
    let { chat_id, sender_id, message, voice, voiceWave, readed } = req.body;

    // Validate user input
    if (!(chat_id && sender_id)) {
      return res.status(200).send({
        status: false,
        message: "All input required!",
        data: null
      });
    }
    const newMessage = {
      chat_id: chat_id,
      sender_id: sender_id,
      message: message,
      voice: voice,
      voiceWave: voiceWave,
      readed: readed
    };
    // socket.socketIoObject.sockets.emit("lastMessage", newMessage);

    Message.create(newMessage)
      .then(data => {
        // socket.socketIoObject.sockets.in(chat_id).emit("message", data);

        return res.status(200).send({
          status: true,
          message: "Success!",
          data: data
        });
      })
      .catch(err => {
        return res.status(200).send({
          status: false,
          message: err.message || "Faild!",
          data: null
        });
      });
  } catch (err) {
    console.log(err);
  }
};

// edit user status online offline
exports.editStatus = async (userId, status) => {
  // Our edit logic starts here
  try {
    const oldStatus = await User.findOne({ where: { id: userId } });

    if (!oldStatus) {
      // return res.status(200).send({
      //   status: false,
      //   message: "User does not exsist in datebase!",
      //   data: null
      // });
      console.log("NEMA USERA");
    }

    if (status) oldStatus.status = status;

    User.update(
      { status: status },
      {
        where: { id: userId }
      }
    )
      .then(async num => {
        const updated = await User.findOne({ where: { id: userId } });

        console.log("USEPEO SAM");
        // return res
        //   .status(200)
        //   .send({ status: true, message: "Updated", data: updated });
      })
      .catch(err => {
        // return res.status(200).send({
        //   status: false,
        //   message: err.message || "Error updating record",
        //   data: null
        // });
        console.log(err.message || "NEKI ERROR");
      });
  } catch (err) {
    console.log(err);
  }
};

exports.uploadVoiceMessage = (req, res, next) => {
  try {
    const { voice } = req.files;

    if (voice) {
      console.log(voice.name);
      // Move the uploaded image to our upload folder
      voice.mv(path.join(__dirname, "..") + "/voices/" + voice.name);

      //   const url = "http://localhost:3000/images/" + image.name
      // "http://api.teleport.scyllasoftware.rs/images/"
      const url = "https://api.teleport.scyllasoftware.rs/voices/" + voice.name;
      // All good

      return res.status(200).send({
        status: true,
        message: "Successfuly uploaded.",
        data: { voiceUrl: url }
      });
    } else {
      return res.status(200).send({
        status: false,
        message: "Faild.",
        data: null
      });
    }
  } catch (err) {
    return res.status(200).send({
      status: false,
      message: err.message || "Some error occurred while uploading images.",
      data: null
    });
  }
};
